<?php
/**
 * Footer Style 03
 * @package senatory
 * @since 1.0.0
 */

$copyright_text = !empty(cs_get_option('copyright_four_text')) ? cs_get_option('copyright_four_text') : esc_html__('Copyright © 2122 Senatory. hjjhjhjhAll Rights Reserved. Designed by ', 'senatory') . '<a href="' . esc_url('https://themeforest.net/user/themeim/portfolio') . '">' . esc_html__('ThemeIM', 'senatory') . '</a>';
$copyright_text = str_replace('{copy}', '&copy;', $copyright_text);
$copyright_text = str_replace('{year}', date('Y'), $copyright_text);
$socialIcon = cs_get_option('footer_social_repeater');

$footer_two_newsletter = cs_get_option('footer_two_newsletter');

?>

<!-- footer area start -->
<footer class="theme-footer-default footer-area line-bg style-04">
    <div class="footer-top issue style-01 <?php if (!is_active_sidebar('footer-widget-three')) {
        echo "divider-extra-wid";
    } else {
        echo "divider-hidden";
    } ?>">
        <div class="container">

            <div class="footer-bottom-border">
                <div class="row">
                    <?php dynamic_sidebar('footer-widget-three'); ?>
                </div>
            </div>
            <div class="copyright-area">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="copyright-area-inner">
                                <?php
                                echo wp_kses($copyright_text, senatory()->kses_allowed_html(array('a')));
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- footer area end -->
  
 