<?php
/**
 * Footer Style 04
 * @package senatory
 * @since 1.0.0
 */

$copyright_text = !empty(cs_get_option('copyright_text')) ? cs_get_option('copyright_text') : esc_html__('Copyright © 2022 Senatory.Hello All Rights . Designed by . ', 'senatory') . '<a href="' . esc_url('https://themeforest.net/user/themeim/portfolio') . '">' . esc_html__('ThemeIM', 'senatory') . '</a>';
$copyright_text = str_replace('{copy}', '&copy;', $copyright_text);
$copyright_text = str_replace('{year}', date('Y'), $copyright_text);
$socialIcon = cs_get_option('footer_social_repeater');

$footer_five_bg_src =   cs_get_option('footer_five_bg_image');
$footer_five_bg_img =   !empty($footer_five_bg_src['background-image']) ? $footer_five_bg_src['background-image']['url'] : 'kiso poua jainai';

// Newsletter
$footer_five_newsletter_bg_src = cs_get_option('footer_five_newsletter_bg');
$footer_five_newsletter_bg_img = !empty($footer_five_newsletter_bg_src['background-image']) ? $footer_five_newsletter_bg_src['background-image']['url'] : 'kiso poua jainai';
// shortcode
$footer_five_newsletter = cs_get_option('footer_five_newsletter');


?>

  <!-- footer area start -->
  <footer class="footer-area" style="background-image: url(<?php echo esc_url($footer_five_bg_img); ?>);">
    <div class="footer-top volunteer">
      <div class="container">
        <div class="footer-top-border style-01 padding-bottom-35">

        <div class="row">
            <div class="col-lg-12">
              <div class="footer-widget widget widget_subscribe political style-01"
              style="background-image: url(<?php echo esc_url($footer_five_newsletter_bg_img); ?>);">
                  <div class="shape-03"></div>
                  <div class="header-content style-01">
                      <h4 class="title style-01"><?php echo esc_html(cs_get_option('footer_five_newsletter_title')); ?></h4>
                      <?php if($footer_two_newsletter): ?>

                    <?php echo do_shortcode($footer_five_newsletter); ?>

                    <?php else: ?>
                      <form action="#" class="footer-form">
                          <div class="form-group">
                              <input type="text" class="form-control" placeholder="Enter Email">
                          </div>
                        </form>
                        <div class="btn-wrapper desktop-center">
                          <a href="#" class="boxed-btn political-btn style-02">SUBSCRIBE NOW<i class="fas fa-paper-plane"></i></a>
                        </div>
                    <?php endif; ?>
                  </div>
              </div>
            </div>
        </div>

          <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-6">
              <div class="footer-widget widget">
                <div class="about_us_widget style-01">
                    <?php
                        $footer_two_logo = cs_get_option('footer_five_logo');
                            if (has_custom_logo() && empty($footer_two_logo['id'])) {
                                the_custom_logo();
                            } elseif (!empty($footer_two_logo['id'])) {
                                printf('<a class="site-logo footer-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $footer_two_logo['url'], $footer_two_logo['alt']);
                            } else {
                                printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                            }
                    ?>
                    <p><?php echo cs_get_option('footer_five_paragraph') ?> </p>
                    <div class="social-links">
                        <?php
                            if (!empty($socialIcon)) :
                                foreach ($socialIcon as $icon) :
                                    echo '<a href=" ' . $icon['footer_social_icon_item_url'] . ' ">
                            <i class="' . $icon['footer_social_icon_item_icon'] . '"></i></a>';
                                endforeach;
                            endif;
                        ?>
                    </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6">
              <div class="footer-widget widget widget_nav_menu">
                <h4 class="widget-title">Explore</h4>
                    <ul class="contact_info_list margin-bottom-50">
                        <?php
                            $infoItem = cs_get_option('footer_five_top_repeater');

                            if (!empty($infoItem)) :
                                foreach ($infoItem as $item) :

                                    echo '
                                <li class="single-info-item">
                                    <div class="icon style-01">
                                    <i class="' . $item['footer_five_info_icon'] . '"></i>
                                    </div>
                                    <div class="details style-01">
                                    ' . $item['footer_five_top_info'] . '
                                    </div>
                                </li>'; 
                                endforeach;
                            endif;
                        ?>
                    </ul>
              </div>
            </div>
            <?php 
            if( is_active_sidebar( 'footer-widget-five' ) ){
                dynamic_sidebar('footer-widget-five'); 
            }
            
            ?>

          </div>
        </div>
        <div class="copyright-area">
          <div class="container">
            <div class="row">
              <div class="col-lg-12">
                <div class="copyright-area-inner">
                    <?php
                        echo wp_kses($copyright_text, senatory()->kses_allowed_html(array('a')));
                    ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </footer>
  <!-- footer area end -->






