<?php
/**
 * Footer Style 01
 * @package senatory
 * @since 1.0.0
 */

$copyright_text = !empty(cs_get_option('copyright_text')) ? cs_get_option('copyright_text') : esc_html__('Paid for by The Dale Folwell for Governor Campaign Committee ', 'senatory') . '<a href="' . esc_url('https://themeforest.net/user/themeim/portfolio') . '">' . esc_html__('', 'senatory') . '</a>';
$copyright_text = str_replace('{copy}', '&copy;', $copyright_text);
$copyright_text = str_replace('{year}', date('Y'), $copyright_text);
$socialIcon = cs_get_option('footer_social_repeater');

$footer_two_newsletter = cs_get_option('footer_five_newsletter');

?>

<!-- footer area start -->
<footer class="theme-footer-default footer-area line-bg">
    <div class="footer-top issue style-01 <?php if (!is_active_sidebar('footer-widget')) {
        echo "divider-extra-wid";
    } else {
        echo "divider-hidden";
    } ?>">
        <div class="container">

            <div class="footer-bottom-border">
                <div class="row">
                    <?php dynamic_sidebar('footer-widget'); ?>
                </div>
            </div>
            <div class="copyright-area">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="copyright-area-inner">
                                <?php
                                echo wp_kses($copyright_text, senatory()->kses_allowed_html(array('a')));
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- footer area end -->
  
 