<?php
/**
 * Header Style 01
 * @package senatory
 * @since 1.0.0
 */

$theme_header_search = cs_get_option('search_bar_enable', true);
$header_btn_enable = cs_get_option('header_btn_enable', true);
$top_text_btn = cs_get_option('top_text_btn');
$top_text_btn_link = cs_get_option('top_text_btn_link');

?>


<div class="header-style-01">
    <!-- Header-top-start -->
    <div class="header-top about theme-header-style-one">
        <div class="container nav-container">
            <div class="row">
                <div class="col-lg-4 col-md-4">
                    <div class="top-social">
                        <ul class="top-social-share mb-0">

                            <?php
                            $socialIcon = cs_get_option('sidebar_social_repeater_header_one');
                            if (!empty($socialIcon)) :
                                foreach ($socialIcon as $icon) :
                                    echo '<li><a href=" ' . $icon['sidebar_social_icon_item_url_one'] . ' ">
										<i class="' . $icon['sidebar_social_icon_item_icon_one'] . '"></i></a></li>';
                                endforeach;
                            endif;
                            ?>


                        </ul>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 align-self-center">
                    <div class="top-single-items">


                        <?php
                        $infoItem = cs_get_option('header_two_info_item_repeater');
                        if (!empty($infoItem)) :
                            foreach ($infoItem as $item) :


                                echo '
				    <div class="top-single-item">
						<div class="icon">
						<i class="' . $item['header_two_info_item_icon'] . '"></i>
						</div>
						<div class="content">
						<h5 class="title"><a href="tel:' . $item['header_two_info_item_url'] . '">' . $item['header_two_info_item_number'] . '</a></h5>
						</div>
					</div>';

                            endforeach;
                        endif;
                        ?>

                        <?php
                        $infoItememail = cs_get_option('header_two_info_item_repeater_email');
                        if (!empty($infoItememail)) :
                            foreach ($infoItememail as $item) :


                                echo '
				    <div class="top-single-item">
						<div class="icon">
						<i class="' . $item['header_two_info_item_icon_email'] . '"></i>
						</div>
						<div class="content">
						<h5 class="title"><a href="mailto:' . $item['header_two_info_item_url_email'] . '">' . $item['header_two_info_item_number_email'] . '</a></h5>
						</div>
					</div>';
                            endforeach;
                        endif;
                        ?>
                        <?php
                        $infoItemnew = cs_get_option('header_two_info_item_repeater_new');
                        if (!empty($infoItemnew)) :
                            foreach ($infoItemnew as $item) :
                                echo '
				    <div class="top-single-item">
						<div class="icon">
						<i class="' . $item['header_two_info_item_icon_new'] . '"></i>
						</div>
						<div class="content">
						<h5 class="title"><a href="' . $item['header_two_info_item_url_new'] . '">' . $item['header_two_info_item_number_new'] . '</a></h5>
						</div>
					</div>';

                            endforeach;
                        endif;
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Header-top-end -->


    <!-- support bar area end -->
    <nav class="navbar navbar-area navbar-expand-lg nav-style-01">
        <div class="container nav-container">
            <div class="responsive-mobile-menu">
                <div class="logo-wrapper">
                    <?php
                    $header_one_logo = cs_get_option('header_one_logo');
                    if (has_custom_logo() && empty($header_one_logo['id'])) {
                        the_custom_logo();
                    } elseif (!empty($header_one_logo['id'])) {
                        printf('<a class="site-logo logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_one_logo['url'], $header_one_logo['alt']);
                    } else {
                        printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                    }
                    ?>
                </div>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#senatory_main_menu"
                        aria-expanded="false" aria-label="<?php esc_attr__('Toggle navigation', 'senatory') ?>">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>

            <?php
            wp_nav_menu(array(
                'theme_location' => 'main-menu',
                'menu_class' => 'navbar-nav',
                'container' => 'div',
                'container_class' => 'collapse navbar-collapse',
                'container_id' => 'senatory_main_menu'
            ));
            ?>
            <div class="nav-right-content">

                <?php if ($theme_header_search == true) : ?>

                    <div class="icon-part">
                        <ul>
                            <li id="search">
                                <a href="<?php echo esc_url('#') ?>">
                                    <i class="icomoon-search-svgrepo-com-1"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                <?php endif; ?>

                <?php if ($header_btn_enable == true) : ?>

                    <div class="btn-wrapper">
                        <a href="<?php echo esc_url($top_text_btn_link); ?>" class="boxed-btn btn-sanatory">
                            <?php echo esc_html($top_text_btn); ?>
                            <i class="icomoon-paper-plan"></i>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </nav>
    <!-- navbar area end -->
</div>

  
  
  
  