<?php
/**
 * Header Style 05
 * @package senatory
 * @since 1.0.0
 */

$header_btn_enable = cs_get_option('header_btn_enable_two', true);
$top_text_btn = cs_get_option('top_text_btn_header_four');
$top_text_btn_link = cs_get_option('top_text_btn_link_header_four');
$header_five_social_icon = cs_get_option('header_social_icon_five');

?>
  
  <div class="header-style-01">
    <!-- support bar area end -->
    <nav class="navbar navbar-area navbar-expand-lg nav-style-02 home-six">
      <div class="container nav-container home-six">
        <div class="responsive-mobile-menu">
          <div class="logo-wrapper">
          <?php
                $header_two_logo = cs_get_option('header_five_logo');
                if (has_custom_logo() && empty($header_two_logo['id'])) {
                    the_custom_logo();
                } elseif (!empty($header_two_logo['id'])) {
                    printf('<a class="site-logo logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_two_logo['url'], $header_two_logo['alt']);
                } else {
                    printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                }
                ?>
          </div>
          <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#bizcoxx_main_menu"
            aria-expanded="false" aria-label="<?php esc_attr__('Toggle navigation', 'senatory') ?>">
            <span class="navbar-toggler-icon"></span>
          </button>
        </div>
        <!-- Main Navigation Menu -->
        <?php 
                wp_nav_menu(array(
                    'theme_location' => 'main-menu',
                    'menu_class' => 'navbar-nav political',
                    'container' => 'div',
                    'container_class' => 'collapse navbar-collapse',
                    'container_id' => 'bizcoxx_main_menu',
                    'fallback_cb' => 'senatory_theme_fallback_menu',
                ));
        ?>


        <div class="nav-right-content style-01">
            <?php if ($header_btn_enable == true) : ?>
            <div class="btn-wrapper">
                <a href="<?php echo esc_url($top_text_btn_link); ?>"
                class="boxed-btn political-btn"><?php echo esc_html($top_text_btn); ?> <i
                            class="icomoon-paper-plan"></i></a>
            </div>
            <?php endif; ?>
            <!-- Header Social Icon -->
            <?php if ($header_five_social_icon == true) : ?>
                <ul class="top-social-share">
                    <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                    <li><a href="#"><i class="fab fa-linkedin-in"></i></a>
                    <li><a href="#"><i class="fab fa-pinterest-p"></i></a></li>
                    <li><a href="#"><i class="fab fa-dribbble"></i></a></li>
                </ul>
           <?php endif; ?>

        </div>

      </div>
    </nav>
    <!-- navbar area end -->
  </div>