<?php
/**
 * Theme Default Header
 * @package senatory
 * @since 1.0.0
 */

$theme_header_search = cs_get_option('search_bar_enable', true);
$header_btn_enable = cs_get_option('header_btn_enable', false);
$top_text_btn = cs_get_option('top_text_btn');
$top_text_btn_link = cs_get_option('top_text_btn_link');

?>

<div class="header-style-01 theme-default-headerone">
    <!-- support bar area end -->
    <nav class="navbar navbar-area navbar-expand-lg nav-style-01">
        <div class="container nav-container">
            <div class="responsive-mobile-menu">
                <div class="logo-wrapper">
                    <?php
                    $header_one_logo = cs_get_option('header_one_logo');
                    if (has_custom_logo() && empty($header_one_logo['id'])) {
                        the_custom_logo();
                    } elseif (!empty($header_one_logo['id'])) {
                        printf('<a class="site-logo logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_one_logo['url'], $header_one_logo['alt']);
                    } else {
                        printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                    }
                    ?>
                </div>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#senatory_main_menu"
                        aria-expanded="false" aria-label="<?php esc_attr__('Toggle navigation','senatory')?>">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>

            <?php
            wp_nav_menu(array(
                'theme_location' => 'main-menu',
                'menu_class' => 'navbar-nav',
                'container' => 'div',
                'container_class' => 'collapse navbar-collapse',
                'container_id' => 'senatory_main_menu',
                'fallback_cb' => 'senatory_theme_fallback_menu',
            ));
            ?>


            <?php if (senatory()->is_senatory_core_active()) : ?>
                <div class="nav-right-content">
                    <?php if ($theme_header_search == true) : ?>
                        <div class="icon-part">
                            <ul>
                                <li id="search"><a href="<?php echo esc_url('#') ?>"><i class="icomoon-search-svgrepo-com-1"></i></a></li>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <?php if ($header_btn_enable == true) : ?>
                        <div class="btn-wrapper">
                            <a href="<?php echo esc_url($top_text_btn_link); ?>" class="boxed-btn btn-sanatory">
                                <?php echo esc_html($top_text_btn); ?>
                                <i class="icomoon-paper-plan"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </nav>
    <!-- navbar area end -->
</div>
  

  
  