<?php
/**
 * Single Event Meta (Details) Template
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe-events/modules/meta/details.php
 *
 * @package TribeEventsCalendar
 * @version 4.6.19
 */


$event_id             = Tribe__Main::post_id_helper();
$time_format          = get_option( 'time_format', Tribe__Date_Utils::TIMEFORMAT );
$time_range_separator = tribe_get_option( 'timeRangeSeparator', ' - ' );
$show_time_zone       = tribe_get_option( 'tribe_events_timezones_show_zone', false );
$time_zone_label      = Tribe__Events__Timezones::get_event_timezone_abbr( $event_id );

$start_datetime = tribe_get_start_date();
$start_date = tribe_get_start_date( null, false );
$start_time = tribe_get_start_date( null, false, $time_format );
$start_ts = tribe_get_start_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );

$end_datetime = tribe_get_end_date();
$end_date = tribe_get_display_end_date( null, false );
$end_time = tribe_get_end_date( null, false, $time_format );
$end_ts = tribe_get_end_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );

$time_formatted = null;
if ( $start_time == $end_time ) {
	$time_formatted = esc_html( $start_time );
} else {
	$time_formatted = esc_html( $start_time . $time_range_separator . $end_time );
}

/**
 * Returns a formatted time for a single event
 *
 * @var string Formatted time string
 * @var int Event post id
 */
$time_formatted = apply_filters( 'tribe_events_single_event_time_formatted', $time_formatted, $event_id );

/**
 * Returns the title of the "Time" section of event details
 *
 * @var string Time title
 * @var int Event post id
 */
$time_title = apply_filters( 'tribe_events_single_event_time_title', esc_html__( 'Time:', 'senatory' ), $event_id );

$cost    = tribe_get_formatted_cost();
$website = tribe_get_event_website_link();
?>

<div class="tribe-events-meta-group tribe-events-meta-group-details">
	<h2 class="tribe-events-single-section-title"> <?php esc_html_e( 'Event Details', 'senatory' ); ?> </h2>
	<ul class="icon-with-title-description">
		<?php
		do_action( 'tribe_events_single_meta_details_section_start' );

		// All day (multiday) events
		if ( tribe_event_is_all_day() && tribe_event_is_multiday() ) :
			?>
        <li>
            <div class="icon"><i class="far fa-calendar-plus"></i></div>
            <div class="content">
                <h4 class="tribe-events-start-date-label"> <?php esc_html_e( 'Start:', 'senatory' ); ?> </h4>
                <span class="tribe-events-abbr tribe-events-start-date published dtstart" title="<?php echo esc_attr( $start_ts ); ?>"> <?php echo esc_html( $start_date ); ?> </span>
            </div>
        </li>
        <li>
            <div class="icon"><i class="far fa-calendar-times"></i></div>
            <div class="content">
                <h4 class="tribe-events-end-date-label"> <?php esc_html_e( 'End:', 'senatory' ); ?> </h4>
                <span class="tribe-events-abbr tribe-events-end-date dtend" title="<?php echo esc_attr( $end_ts ); ?>"> <?php echo esc_html( $end_date ); ?> </span>
            </div>
        </li>

		<?php
		// All day (single day) events
		elseif ( tribe_event_is_all_day() ):
			?>
            <li>
                <div class="icon"><i class="far fa-calendar-alt"></i></div>
                <div class="content">
			        <h4 class="tribe-events-start-date-label"> <?php esc_html_e( 'Date:', 'senatory' ); ?> </h4>
                    <span class="tribe-events-abbr tribe-events-start-date published dtstart" title="<?php echo esc_attr( $start_ts ); ?>"> <?php echo esc_html( $start_date ); ?> </span>
                </div>
            </li>
		<?php
		// Multiday events
		elseif ( tribe_event_is_multiday() ) :
			?>
            <li>
                <div class="icon"><i class="far fa-calendar-plus"></i></div>
                <div class="content">
			        <h4 class="tribe-events-start-datetime-label"> <?php esc_html_e( 'Start:', 'senatory' ); ?> </h4>
                    <span class="tribe-events-abbr tribe-events-start-datetime updated published dtstart" title="<?php echo esc_attr( $start_ts ); ?>"> <?php echo esc_html( $start_datetime ); ?> </span>
	                <?php if ( $show_time_zone ) : ?>
                        <span class="tribe-events-abbr tribe-events-time-zone published "><?php echo esc_html( $time_zone_label ); ?></span>
	                <?php endif; ?>
                </div>
            </li>
            <li>
                <div class="icon"><i class="far fa-calendar-times"></i></div>
                <div class="content">
			        <h4 class="tribe-events-end-datetime-label"> <?php esc_html_e( 'End:', 'senatory' ); ?> </h4>
                    <span class="tribe-events-abbr tribe-events-end-datetime dtend" title="<?php echo esc_attr( $end_ts ); ?>"> <?php echo esc_html( $end_datetime ); ?> </span>
	                <?php if ( $show_time_zone ) : ?>
                        <span class="tribe-events-abbr tribe-events-time-zone published "><?php echo esc_html( $time_zone_label ); ?></span>
	                <?php endif; ?>
                </div>
            </li>

		<?php
		// Single day events
		else :
			?>
            <li>
                <div class="icon"><i class="far fa-calendar-alt"></i></div>
                <div class="content">
			        <h4 class="tribe-events-start-date-label"> <?php esc_html_e( 'Date:', 'senatory' ); ?> </h4>
				    <span class="tribe-events-abbr tribe-events-start-date published dtstart" title="<?php echo esc_attr( $start_ts ); ?>"> <?php echo esc_html( $start_date ); ?> </span>
                </div>
            </li>
            <li>
                <div class="icon"><i class="far fa-clock"></i></div>
                <div class="content">
			        <h4 class="tribe-events-start-time-label"> <?php echo esc_html( $time_title ); ?> </h4>
                    <div class="tribe-events-abbr tribe-events-start-time published dtstart" title="<?php echo esc_attr( $end_ts ); ?>">
                        <?php echo wp_kses($time_formatted,senatory()->kses_allowed_html('all')); ?>
                        <?php if ( $show_time_zone ) : ?>
                            <span class="tribe-events-abbr tribe-events-time-zone published "><?php echo esc_html( $time_zone_label ); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
		<?php endif ?>

		<?php
		// Event Cost
		if ( ! empty( $cost ) ) : ?>
            <li>
                <div class="icon"><i class="fas fa-dollar-sign"></i></div>
                <div class="content">
                    <h4 class="tribe-events-event-cost-label"> <?php esc_html_e( 'Cost:', 'senatory' ); ?> </h4>
                    <span class="tribe-events-event-cost"> <?php echo esc_html( $cost ); ?> </span>
                </div>
            </li>
		<?php endif ?>

		<?php
		echo tribe_get_event_categories(
			get_the_id(), array(
				'before'       => '',
				'sep'          => ', ',
				'after'        => '',
				'label'        => null, // An appropriate plural/singular label will be provided
				'label_before' => '<li><div class="icon"><i class="far fa-folder-open"></i></div><div class="content"><h4 class="tribe-events-event-categories-label">',
				'label_after'  => '</h4>',
				'wrap_before'  => '<div class="tribe-events-event-categories">',
				'wrap_after'   => '</div></div></li>',
			)
		);
		?>
		        <?php senatory()->tribe_meta_event_tags( sprintf( esc_html__( '%s Tags:', 'senatory' ), tribe_get_event_label_singular() ), ', ', true ); ?>

		<?php
		/* Translators: %s: Event (singular) */
		?>

		<?php
		// Event Website
		if ( ! empty( $website ) ) : ?>
            <li>
                <div class="icon"><i class="fas fa-globe"></i></div>
                <div class="content">
                    <h4 class="tribe-events-event-url-label"> <?php esc_html_e( 'Website:', 'senatory' ); ?> </h4>
			        <span class="tribe-events-event-url"> <?php echo esc_url( $website); ?> </span>
                </div>
            </li>
		<?php endif ?>

		<?php do_action( 'tribe_events_single_meta_details_section_end' ); ?>
	</ul>
</div>
