<?php
/**
 * Single Event Meta (Organizer) Template
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe-events/modules/meta/organizer.php
 *
 * @package TribeEventsCalendar
 * @version 4.6.19
 */

$organizer_ids = tribe_get_organizer_ids();
$multiple = count( $organizer_ids ) > 1;
$phone = tribe_get_organizer_phone();
$email = tribe_get_organizer_email();
$website = tribe_get_organizer_website_link();
?>

<div class="tribe-events-meta-group tribe-events-meta-group-organizer">
	<h2 class="tribe-events-single-section-title"><?php echo tribe_get_organizer_label( ! $multiple ); ?></h2>
	<ul class="icon-with-title-description">
		<?php
		do_action( 'tribe_events_single_meta_organizer_section_start' );

		foreach ( $organizer_ids as $organizer ) {
			if ( ! $organizer ) {
				continue;
			}
			?>
            <li>
                <div class="icon"><i class="fas fa-store"></i></div>
                <div class="content">
                    <h4><?php echo esc_html('Name')?></h4>
                    <span class="tribe-organizer">
                        <?php echo tribe_get_organizer_link( $organizer ) ?>
                    </span>
                </div>
            </li>

			<?php
		}

		if ( ! $multiple ) { // only show organizer details if there is one
			if ( ! empty( $phone ) ) {
				?>
                <li>
                    <div class="icon"><i class="fas fa-phone"></i></div>
                    <div class="content">
                        <h4 class="tribe-organizer-tel-label">
		                    <?php esc_html_e( 'Phone:', 'senatory' ) ?>
                        </h4>
                        <span class="tribe-organizer-tel">
                            <?php echo esc_html( $phone ); ?>
                        </span>
                    </div>
                </li>
				<?php
			}//end if

			if ( ! empty( $email ) ) {
				?>
                <li>
                    <div class="icon"><i class="far fa-envelope"></i></div>
                    <div class="content">
                        <h4 class="tribe-organizer-email-label">
		                    <?php esc_html_e( 'Email:', 'senatory' ) ?>
                        </h4>
                        <span class="tribe-organizer-email">
                            <?php echo esc_html( $email ); ?>
                        </span>
                    </div>
                </li>

				<?php
			}//end if

			if ( ! empty( $website ) ) {
				?>
                <li>
                    <div class="icon"><i class="fas fa-globe"></i></div>
                    <div class="content">
                        <h4 class="tribe-organizer-url-label">
		                    <?php esc_html_e( 'Website:', 'senatory' ) ?>
                        </h4>
                        <span class="tribe-organizer-url">
                            <?php esc_url($website); ?>
                        </span>
                    </div>
                </li>
				<?php
			}//end if
		}//end if

		do_action( 'tribe_events_single_meta_organizer_section_end' );
		?>
	</ul>
</div>
