<?php
/**
 * Single Event Template
 * A single event. This displays the event title, description, meta, and
 * optionally, the Google map for the event.
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/single-event.php
 *
 * @package TribeEventsCalendar
 * @version 4.6.19
 *
 */

if (!defined('ABSPATH')) {
    die('-1');
}

$events_label_singular = tribe_get_event_label_singular();
$events_label_plural = tribe_get_event_label_plural();
$event_id = get_the_ID();

$event_start_time = get_post_meta($event_id, '_EventStartDate', true);

// Check for skeleton mode (no outer wrappers per section)
$not_skeleton = !apply_filters('tribe_events_single_event_the_meta_skeleton', false, get_the_ID());

// Do we want to group venue meta separately?
$set_venue_apart = apply_filters('tribe_events_single_event_the_meta_group_venue', false, get_the_ID());


$event_single_meta_data = get_post_meta(get_the_ID(), 'senatory_event_options', true);

$event_breadcrumb_img = isset($event_single_meta_data['event_breadcrumb_image']) ? $event_single_meta_data['event_breadcrumb_image'] : [];

if (array_key_exists('event_form', $event_single_meta_data)) {
    $event_form_shortcode = $event_single_meta_data['event_form'];
} else {
    $event_form_shortcode = '';
}
// CS
$contye_type = cs_get_option('senatory_event_single_style') ?? 'one';
$related_post = cs_get_option('senatory_events_related_post_switcher') ?? '';
$events_comment = cs_get_option('senatory_events_comment') ?? '';

$senatory = senatory();
$page_layout_meta = Senatory_Group_Fields_Value::event_single_page_layout_options('events_single');
$full_width_class = $page_layout_meta['content_column_class'] === 'col-lg-12' ? ' full-width-content ' : '';


if ($senatory->is_senatory_core_active()){
    senatory_core()->setPostViews(get_the_ID());
}
?>
    <div class="event-content-section  margin-top-20 <?php echo esc_attr($full_width_class);?>">
        <div class="container">
            <div class="row">
                <div class="<?php echo esc_attr($page_layout_meta['content_column_class']);?>">
                    <?php
                    while ( have_posts() ) : the_post(); 
                        $post_meta = get_post_meta(get_the_ID());                                       
 
                        get_template_part( 'template-parts/events-content/content', $contye_type );
                        
                        ?>
                        
                        <?php    
                           if($related_post ):   
                            // If comments are open or we have at least one comment, load up the comment template.
                            if ( comments_open() || get_comments_number() || get_option( 'thread_comments' )) :
                                comments_template();
                            endif;
                           endif; // End of comment switcher
                    endwhile; // End of the loop.
                    ?>
                </div>
                <?php if ($page_layout_meta['sidebar_enable']): ?>
                <div class="<?php echo esc_attr($page_layout_meta['sidebar_column_class']);?>">
                    <?php get_sidebar();?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div><!-- #primary -->


    <!-- More Issue Section Start Here -->
<!-- content Goes there -->
    <!-- More Event Section End Here -->



<?php
get_footer();






					
					